/**********************************************************************************************
* Device      : AD18F08
* Author      : fengxuanmian
* Version     : V0.0.1
* Date        : 2023.5.5
* Description : 配置字中选择2T模式(一个指令周期为两个机器周期)
*               使用系统时钟作为tmr0的计数时钟源,2分频,打开buzzer PA4将输出20K的buzzer信号
*               配置字中也可选择4T模式(一个指令周期为四个机器周期)
*               使用系统时钟作为tmr0的计数时钟源,2分频,打开buzzer PA4将输出10K的buzzer信号
***********************************************************************************************/

#include "AD18F08.h"

/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式(使能后DEBUG口不能做普通IO用)
* _LVREN_OFF         :  禁止LVR
* _LVR24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL				:  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_2T          :  选择指令周期为4T模式
* _WDTE_OFF         :  看门狗使能位
* _TWDT_101         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _ADCSP_ON			:  ADC采集速度选择位

*
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
*
************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_ON_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_2T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    &_ADCSP_ON_4L                                                                                      );

/*        时钟频率/计数分频/指令周期 = 计数频率    (指令周期选择为4T)
                16M/2/4  =  2M
         一次计数时间:1s/2000000 = 0.5us
BUZZER 10Khz(中断周期20K)  需要计数 0.05ms/0.5us = 100   故T0周期取100*/

/*        时钟频率/计数分频/指令周期 = 计数频率    (指令周期选择为2T)
                16M/2/2  =  4M
         一次计数时间:1s/4000000 = 0.25us
BUZZER 20Khz(中断周期40K)  需要计数 0.025ms/0.25us = 100   故T0周期取100*/
//---------配置字 FCPU 可选--------------
//_FCPU_4T_3L         4T模式
//_FCPU_2T_3L         2T模式
//------------------------

void main (void)
{
  	//时钟源选择CPU(16M)   T0使能分频   2分频
    TRISA4 = 0;            //PA4设置输出
	T0CON = 0X80;         //启动BUZZEE （PA4口输出）
	T0CON |= 0 << 5;      //时钟源选择CPU运行时钟
	T0CON |= 0 << 3;      //分频使能
	T0CON |= 0;           //2分频

	PR0 = 100;            //计数周期
	TMR0 = 0;             //计数初值
	T0CLKEN = 1;          //使能T0的时钟

	while(1)
	{

	}
}

//高优先级中断服务函数
void interrupt ISR_h (void)
{
//当前范例未使用
}

//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{
//当前范例未使用
}
